/*=============================================================================
  (C)2023 HIL Lab.ALL RIGHT RESERVED.

  Redistribution of this file, in original or modified form, without
  prior written consent of HIL Lab is prohibited.

-------------------------------------------------------------------------------

  File:        main.cc

  Description: Example source of AttenuatorHandler API.

-------------------------------------------------------------------------------

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF TITLE,
  NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR  PURPOSE ARE
  DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=============================================================================*/

#include "attenuator_handler.h"
#include <iostream>
#include <string>

using namespace std;
using namespace HILLAB;

int main (void) {
  AttenuatorHandler handler;
  string device_name;
  cout << "INPUT DEVICE PORT NAME: ";
  cin >> device_name;
  if (!handler.Connect(device_name)) {
    cout << "Device " << device_name << " not found." << endl;
    return 0;
  }
  
  int choice = 0;
  double curr_offset = 0.0;
  while (true) {
    float curr_transmittance, curr_degree;
    handler.GetTransmittance(&curr_transmittance, curr_offset);
    handler.GetMotorDegree(&curr_degree);
    cout << "<Current properties>" << endl;
    cout << "- Transmittance offset= " << curr_offset << endl;
    cout << fixed << "- Transmittance= " << curr_transmittance
      << "(abs degree= " << curr_degree << ")" << endl;
    cout << "  1. Change transmittance offset" << endl;
    cout << "  2. Set transmittance" << endl;
    cout << "  3. Set degree" << endl;
	  cout << "  4. Mechanical calibration" << endl;
    cout << "  0. Disconnect and exit" << endl;
    cout << "   : "; cin >> choice;

    AttenuatorStatus err = AttenuatorStatus::OK;

    switch (choice) {
      case 0: {
        handler.Disconnect(); 
        return 0;
      }
      case 1: {
		    cout << "     transmittance offset: "; cin >> curr_offset;
        break;
      }
      case 2: {
        float new_transmittance = curr_transmittance;
        cout << "     transmittance: "; cin >> new_transmittance;
        cout << "     Set transmittance to " << new_transmittance << endl;
        err = handler.SetTransmittance(new_transmittance, curr_offset);
        break;
      }
      case 3: {
        float new_degree = curr_degree;
        cout << "     degree: "; cin >> new_degree;
        cout << "     Set offset to " << new_degree << endl;
        err = handler.SetMotorDegree(new_degree); 
        break;
      }
      case 4: {
        err = handler.MechanicalCalibration();
        break;
      }
    }
    cout << " Operation left error code " << static_cast<int>(err) << endl;
    cout << "--------------------------------" << endl;
    cout << endl;
  }
  return 0;
}